/*******************************************************************************
 * Copyright (c) 2000, 2013 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jdt.ui.tests.refactoring.reorg;

import junit.framework.Test;
import junit.framework.TestSuite;

public class AllReorgPerformanceTests {

	public static Test suite() {
		TestSuite suite= new TestSuite(AllReorgPerformanceTests.class.getName());
		suite.addTest(RenamePackagePerfTests1.suite());
		suite.addTest(RenamePackagePerfTests2.suite());

		suite.addTest(RenameTypePerfAcceptanceTests.suite());
		suite.addTest(RenameTypePerfTests1.suite());
		suite.addTest(RenameTypePerfTests2.suite());

		suite.addTest(RenameMethodPerfTests1.suite());
		suite.addTest(RenameMethodPerfTests2.suite());
		suite.addTest(RenameMethodWithOverloadPerfTests.suite());

		suite.addTest(MoveCompilationUnitPerfTests1.suite());
		suite.addTest(MoveCompilationUnitPerfTests2.suite());

		suite.addTest(MoveStaticMembersPerfTests1.suite());
		suite.addTest(MoveStaticMembersPerfTests2.suite());

		suite.addTest(IntroduceIndirectionPerfAcceptanceTests.suite());

		return suite;
	}
}
